/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.ws.api.WSParam;
import filenet.ws.api.WSParamLeaf;
import filenet.ws.api.WSParamParent;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSParamArray
extends WSParamParent {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSParamArray";
    protected WSParam m_sampleArrayElement = null;
    protected String m_minOccurs = null;
    protected String m_maxOccurs = null;
    protected int m_min = 0;
    protected int m_max = Integer.MAX_VALUE;
    protected int m_length = 0;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:26  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.13  $";
    }

    public void releaseReferences() {
        block3: {
            try {
                if (this.m_sampleArrayElement != null) {
                    WSParam sampleArrayElement = this.m_sampleArrayElement;
                    this.m_sampleArrayElement = null;
                    sampleArrayElement.releaseReferences();
                    sampleArrayElement = null;
                }
                super.releaseReferences();
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block3;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSParamArray(WSParamParent parent, String name, String namespace, String typeNSPrefix, String typeName, WSParam sampleArrayElement, String min, String max) {
        super(parent, name, namespace, typeNSPrefix, typeName);
        this.m_bBaseType = false;
        this.m_minOccurs = min;
        this.m_maxOccurs = max;
        try {
            this.m_min = Integer.parseInt(min);
        }
        catch (NumberFormatException e) {
            this.m_min = 0;
        }
        try {
            this.m_max = Integer.parseInt(max);
        }
        catch (NumberFormatException e) {
            this.m_max = Integer.MAX_VALUE;
        }
        this.setSampleElement(sampleArrayElement);
    }

    public WSParam addArrayElement() {
        this.setArrayLength(this.m_length + 1);
        return this.getArrayElement(this.m_length - 1);
    }

    protected void addTemplateElement(Document doc, Element pElement, int bindingStyle) {
        String prefix;
        String name;
        Element elt = pElement;
        WSParam parent = this.getParent();
        WSParam[] siblings = null;
        if (parent != null && parent instanceof WSParamParent) {
            siblings = ((WSParamParent)parent).getChildren();
        }
        if (this.isRPC() && siblings != null && siblings.length > 1) {
            elt = doc.createElement(this.getName());
        }
        if (bindingStyle == 2 && (name = this.getSampleElement().getTypeName()) != null & (prefix = this.getSampleElement().getTypeNamespacePrefix()) != null) {
            elt.setAttribute("soapenc:arrayType", prefix + ":" + name + "[]");
        }
        String s = this.getName() + " is an array of " + this.m_minOccurs + " to " + this.m_maxOccurs + " element(s)";
        elt.appendChild(doc.createComment(s));
        s = "Start of an array element";
        elt.appendChild(doc.createComment(s));
        this.getSampleElement().addTemplateElement(doc, elt, bindingStyle);
        s = "End of an array element";
        elt.appendChild(doc.createComment(s));
        if (elt != pElement) {
            pElement.appendChild(elt);
        }
    }

    protected Element[] createElements(Document doc, int bindingStyle) {
        Element[] elements = null;
        Vector<Element> v = null;
        if (this.m_children != null && this.m_children.size() > 0) {
            v = new Vector<Element>();
            Object obj = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                obj = this.m_children.get(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                v.add(((WSParam)obj).createElement(doc, bindingStyle));
            }
        }
        if (v != null && v.size() > 0) {
            elements = new Element[v.size()];
            v.toArray(elements);
            v.clear();
        }
        return elements;
    }

    protected boolean isSameNamespace(String namespace) {
        if (this.m_parent != null) {
            return this.m_parent.isSameNamespace(namespace);
        }
        return super.isSameNamespace(namespace);
    }

    protected Element createTemplateElement(Document doc, int bindingStyle) {
        Vector children = this.m_children;
        this.m_children = null;
        Element element = super.createTemplateElement(doc, bindingStyle);
        String s = this.getName() + " is an array of " + this.m_minOccurs + " to " + this.m_maxOccurs + " element(s)";
        element.appendChild(doc.createComment(s));
        s = "Start of an array element";
        element.appendChild(doc.createComment(s));
        element.appendChild(this.getSampleElement().createTemplateElement(doc, bindingStyle));
        s = "End of an array element";
        element.appendChild(doc.createComment(s));
        this.m_children = children;
        return element;
    }

    public WSParam[] getArray() {
        if (this.m_children != null && this.m_children.size() > 0) {
            WSParam[] array = new WSParam[this.m_children.size()];
            this.m_children.toArray(array);
            return array;
        }
        return null;
    }

    public WSParam getArrayElement(int index) {
        if (this.m_children != null && index >= 0 && index < this.m_length) {
            Object obj = this.m_children.get(index);
            if (obj != null && obj instanceof WSParam) {
                return (WSParam)obj;
            }
            WSParam element = this.newArrayElement();
            this.m_children.set(index, element);
            return element;
        }
        return null;
    }

    public int getArrayLength() {
        return this.m_length;
    }

    public WSParam insertArrayElementAt(int index) {
        if (index >= 0 && index <= this.m_length && this.m_length < this.m_max) {
            WSParam element = this.newArrayElement();
            this.m_children.insertElementAt(element, index);
            return element;
        }
        return null;
    }

    public boolean isArray() {
        return true;
    }

    public void moveDown(int index) {
        if (index > 0 && index < this.m_length - 1) {
            Object obj = this.m_children.remove(index);
            this.m_children.insertElementAt(obj, index + 1);
        }
    }

    public void moveUp(int index) {
        if (index > 0 && index < this.m_length) {
            Object obj = this.m_children.remove(index);
            this.m_children.insertElementAt(obj, index - 1);
        }
    }

    protected void populate(Node node) {
        if (node != null) {
            Object obj = null;
            if (this.m_sampleArrayElement != null) {
                String nodeName = node.getNodeName();
                nodeName = node.getNodeName();
                if (VWStringUtils.compare(nodeName, this.getName()) == 0) {
                    this.setArrayLength(this.getArrayLength() + 1);
                    WSParam arrayElement = this.getArrayElement(this.getArrayLength() - 1);
                    arrayElement.populate(node);
                }
            }
        }
    }

    protected void removeAll() {
        super.removeAll();
        if (this.m_sampleArrayElement != null) {
            this.m_sampleArrayElement.removeAll();
        }
        this.m_sampleArrayElement = null;
        this.m_minOccurs = null;
        this.m_maxOccurs = null;
    }

    protected WSParam removeArrayElementAt(int index) {
        if (index >= 0 && index < this.m_length && this.m_length > this.m_min) {
            --this.m_length;
            return (WSParam)this.m_children.remove(index);
        }
        return null;
    }

    protected void reset() {
        super.reset();
        if (this.m_children != null) {
            this.m_children.removeAllElements();
        }
    }

    public void setArrayLength(int length) {
        if (this.m_children == null) {
            this.m_children = new Vector();
        }
        if (length < this.m_min) {
            length = this.m_min;
        }
        if (length > this.m_max) {
            length = this.m_max;
        }
        this.m_children.setSize(length);
        if (this.m_length < length) {
            for (int i = this.m_length; i < length; ++i) {
                this.m_children.setElementAt(this.newArrayElement(), i);
            }
        }
        this.m_length = length;
    }

    public String toString() {
        String s = new String("******** array *******\n");
        s = s + super.toString();
        s = s + "Sample array elements\n";
        s = s + this.getSampleElement().toString();
        s = s + "End of Sample array elements\n";
        s = s + "******** end of array " + this.getName() + "\n\n";
        return s;
    }

    public String toXML() {
        String s = new String();
        if (this.m_children != null && this.m_children.size() > 0) {
            Object obj = null;
            for (int i = 0; i < this.m_children.size(); ++i) {
                obj = this.m_children.get(i);
                if (obj == null || !(obj instanceof WSParam)) continue;
                s = s + ((WSParam)obj).toXML();
            }
        }
        return s;
    }

    public String toXMLTemplate() {
        String s = new String();
        s = s + "<" + this.getName();
        s = this.m_parent != null && this.m_parent.isSameNamespace(this.m_namespace) ? s + ">\n" : s + " xmlns='" + this.getNamespace() + "'>\n";
        s = s + "<!--" + this.getName() + " is an array of " + this.m_minOccurs + " to " + this.m_maxOccurs + " element(s)-->\n";
        s = s + "<!--Start of an array element-->\n";
        s = s + this.getSampleElement().toXMLTemplate();
        s = s + "<!--End of an array element-->\n";
        s = s + "</" + this.getName() + ">\n";
        return s;
    }

    protected WSParam clone(WSParamParent parent) {
        WSParamArray clone = new WSParamArray(parent, this.getName(), this.getNamespace(), this.getTypeNamespacePrefix(), this.getTypeName(), this.m_sampleArrayElement, this.m_minOccurs, this.m_maxOccurs);
        this.copyTo(clone);
        return clone;
    }

    protected void copyTo(WSParamArray to) {
        super.copyTo(to);
    }

    protected Vector getFlatParamList() {
        Vector<WSParamArray> list = new Vector<WSParamArray>();
        Vector subList = null;
        list.add(this);
        subList = this.m_sampleArrayElement.getFlatParamList();
        if (subList != null) {
            list.addAll(subList);
        }
        return list;
    }

    protected WSParam newArrayElement() {
        return this.getSampleElement().clone(this.m_parent);
    }

    protected void setArray(WSParam[] array) {
        if (this.m_children != null) {
            this.m_children.removeAllElements();
        } else {
            this.m_children = new Vector();
        }
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] != null) {
                    this.m_children.add(array[i]);
                    continue;
                }
                this.m_children.add(this.newArrayElement());
            }
        }
        this.m_length = array.length;
    }

    protected void setArray(Vector array) {
        if (this.m_children != null) {
            this.m_children.removeAllElements();
        } else {
            this.m_children = new Vector();
        }
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                if (array.get(i) != null) {
                    this.m_children.add(array.get(i));
                    continue;
                }
                this.m_children.add(this.newArrayElement());
            }
        }
        this.m_length = array.size();
    }

    protected WSParam getSampleElement() {
        if (this.m_sampleArrayElement == null) {
            String typeName = null;
            if (this.m_typeName != null) {
                int index = this.m_typeName.indexOf("[");
                typeName = index != -1 ? this.m_typeName.substring(0, index) : this.m_typeName;
            }
            this.m_sampleArrayElement = new WSParamLeaf(this, this.getName(), this.getNamespace(), this.getTypeNamespacePrefix(), typeName);
        }
        return this.m_sampleArrayElement;
    }

    private void setSampleElement(WSParam sampleArrayElement) {
        this.m_sampleArrayElement = sampleArrayElement;
        if (this.m_sampleArrayElement != null) {
            this.m_sampleArrayElement.m_parent = this;
            if (this.m_min > 0) {
                this.setArrayLength(this.m_min);
            }
            this.m_sampleArrayElement.setArrayElement(true);
        }
    }

    public String getArrayElementName() {
        if (this.m_sampleArrayElement != null) {
            return this.m_sampleArrayElement.getName();
        }
        return null;
    }

    public String getArrayElementNamespace() {
        if (this.m_sampleArrayElement != null) {
            return this.m_sampleArrayElement.getNamespace();
        }
        return null;
    }

    public int getArrayElementType() {
        if (this.m_sampleArrayElement != null) {
            return this.m_sampleArrayElement.getType();
        }
        return this.getType();
    }

    public String getArrayElementTypeName() {
        if (this.m_sampleArrayElement != null) {
            return this.m_sampleArrayElement.getTypeName();
        }
        return this.getTypeName();
    }

    public String getArrayElementAttribute() {
        if (this.m_sampleArrayElement != null) {
            return this.m_sampleArrayElement.getAttribute();
        }
        return this.getAttribute();
    }
}

